import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;

import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import some.UserInfo;
import some.UserInfo3;
import some.UserInfo4;
import some.UserList;
import some.UserList2;
import some.UserList3;


public class SampleClient {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		DOMConfigurator.configure("config/log4j.xml");

		SampleClient me = new SampleClient();
		me.createAccountBook();
		me.loadAndSaveXML();
		me.loadAndSaveAnnotation();
	}

	@SuppressWarnings("unchecked")
	private void createAccountBook() {
		// قȂ book, قȂV[gAɃtH[}bgقȂ邻ꂼ̕\A
		// ܂Ƃ߂P̑䒠쐬ꍇ
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/Account.xml");
		try {
			ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("UserList");
			ArrayList<UserInfo> userListShinagawa = (ArrayList<UserInfo>)bridge.load(
					"./files/upload/.xls",
					"i");
			ArrayList<UserInfo> userListOota = (ArrayList<UserInfo>)bridge.load(
					"./files/upload/.xls",
					"c");
			ArrayList<UserInfo> userListYokohama = (ArrayList<UserInfo>)bridge.load(
					"./files/upload/_ސ.xls",
					"ls");
			ArrayList<UserInfo> userListKawasaki = (ArrayList<UserInfo>)bridge.load(
					"./files/upload/_ސ.xls",
					"s");

			ArrayList<UserInfo> userListAll = new ArrayList<UserInfo>();
			userListAll.addAll(userListShinagawa);
			userListAll.addAll(userListOota);
			userListAll.addAll(userListYokohama);
			userListAll.addAll(userListKawasaki);

			bridge.save(
					"./files/template/䒠_template.xls",
					"Users",
					"./files/export/䒠.xls",
					userListAll);

		} catch (ExcelPOJOException e) {
			e.printStackTrace();
		}
	}
	@SuppressWarnings("unchecked")
	private void loadAndSaveXML() {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/User.xml");
		Map<String, Integer> workingHours = null;
		try {
			ExcelPOJOBridge bridge1 = (ExcelPOJOBridge)context.getBean("UserList1");
			UserList userList1 = (UserList)bridge1.load(
								"./files/upload/example_1.xls",
								"Users");

			System.out.printf("\n== UserList1(%s) ==================\n\n", userList1.getClass());
			System.out.println(userList1.toString());
			System.out.println("\n===============================\n");System.out.flush();

			bridge1.save(
					"./files/template/example_template.xls",
					"Users2",
					"./files/export/XML_1.xls",
					userList1);
			System.out.println("\n=== save1 finished =============\n");System.out.flush();

			ExcelPOJOBridge bridge2 = (ExcelPOJOBridge)context.getBean("UserList2");
			UserList userList2 = (UserList)bridge2.load(
					"./files/upload/example_1.xls",
					"Users2");

			System.out.printf("\n=== UserList2(%s) =================\n\n", userList2.getClass());
			System.out.println(userList2.toString());
			System.out.println("\n===============================\n");System.out.flush();

			bridge2.save(
					"./files/template/example_template.xls",
					"Users3",
					"./files/export/XML_2.xls",
					userList2);
			System.out.println("\n=== save2 finished =============\n");System.out.flush();

			ExcelPOJOBridge bridge3 = (ExcelPOJOBridge)context.getBean("UserList3_1");
			LinkedList<UserInfo> userList3_1 = new LinkedList<UserInfo>((List<UserInfo>)bridge3.load(
					"./files/upload/example_1.xls",
					"Users"));
			System.out.printf("\n=== UserList3_1(%s) =================\n", userList3_1.getClass());
			for (UserInfo userInfo : userList3_1) {
				System.out.println(userInfo.toString());
			}
			System.out.println("\n===============================\n");System.out.flush();

			bridge3.save("./files/template/example_template.xls",
						"Users2",
						"./files/export/XML_3_1.xls",
						userList3_1);
			System.out.println("\n=== save3_1 finished =============\n");System.out.flush();

			ExcelPOJOBridge bridge3_2 = (ExcelPOJOBridge)context.getBean("UserList3_2");
			LinkedList<UserInfo> userList3_2 = new LinkedList<UserInfo>((List<UserInfo>)bridge3_2.load(
					"./files/upload/example_1.xls",
					"Users"));
			System.out.printf("\n=== UserList3_2(%s) =================\n", userList3_2.getClass());
			for (UserInfo userInfo : userList3_2) {
				System.out.println(userInfo.toString());
			}
			System.out.println("\n===============================\n");System.out.flush();

			bridge3_2.save("./files/template/example_template.xls",
						"Users2",
						"./files/export/XML_3_2.xls",
						userList3_2);
			System.out.println("\n=== save3_2 finished =============\n");System.out.flush();

			ExcelPOJOBridge bridge4 = (ExcelPOJOBridge)context.getBean("UserList4");
			UserInfo[] userList4 = (UserInfo[])bridge4.load(
					"./files/upload/example_1.xls",
					"Users2");
			System.out.printf("\n=== UserList4(%s) =================\n", userList4.getClass());
			for (UserInfo userInfo : userList4) {
				System.out.println(userInfo.toString());
			}
			System.out.println("\n===============================\n");System.out.flush();

			bridge4.save("./files/template/example_template.xls",
						"Users3",
						"./files/export/XML_4.xls",
						userList4);
			System.out.println("\n=== save4 finished =============\n");System.out.flush();

			ExcelPOJOBridge bridge5 = (ExcelPOJOBridge)context.getBean("UserList5");
			workingHours = (Map<String, Integer>)bridge5.load(
					"./files/upload/example_1.xls",
					"Users2");
			System.out.printf("\n=== (%s) ==============\n", workingHours.getClass());
			for (String key : workingHours.keySet()) {
				System.out.println(String.format("key=%s, value=%s",key, workingHours.get(key)));
			}
			System.out.println("\n===============================\n");System.out.flush();

			bridge5.save("./files/template/example_template.xls",
						"Users3",
						"./files/export/XML_5.xls",
						workingHours);
			System.out.println("\n=== save5 finished =============\n");System.out.flush();

		} catch (ExcelPOJOException e) {
			e.printStackTrace();
		}
	}

	@SuppressWarnings("unchecked")
	private void loadAndSaveAnnotation() {
		try {
			ExcelPOJOBridge bridge = new ExcelPOJOBridge(UserList2.class);
			UserList2 userList1_1 = (UserList2) bridge.load("./files/upload/example_1.xls", "Users");
			System.out.println("\n== userList1_1 ==================\n");
			System.out.println(userList1_1.toString());
			System.out.println("\n===============================\n");System.out.flush();

			bridge.save("./files/template/example_template.xls",
					"Users2",
					"./files/export/Annotation_1.xls",
					userList1_1);
			System.out.println("\n=== save1_1 finished =============\n");System.out.flush();

			ExcelPOJOBridge bridge1_2 = new ExcelPOJOBridge(UserList3.class);
			UserList3 userList1_2 = (UserList3) bridge1_2.load("./files/upload/example_1.xls", "Users2");
			System.out.println("\n== userList1_2 ==================\n");
			System.out.println(userList1_2.toString());
			System.out.println("\n===============================\n");System.out.flush();

			bridge1_2.save("./files/template/example_template.xls",
					"Users3",
					"./files/export/Annotation_1_2.xls",
					userList1_2);
			System.out.println("\n=== save1_2 finished =============\n");System.out.flush();

			// Ame[VXML̐ݒDŒl擾
			ApplicationContext context = new ClassPathXmlApplicationContext("./config/User.xml");
			ExcelPOJOBridge bridge2 = (ExcelPOJOBridge)context.getBean("UserList6");
			UserList3 userList2 = (UserList3) bridge2.load("./files/upload/example_1.xls", "Users2");
			System.out.println("\n== userList2 ==================\n");
			System.out.println(userList2.toString());
			System.out.println("\n===============================\n");System.out.flush();

			bridge2.save("./files/template/example_template.xls",
					"Users3",
					"./files/export/Annotation_2.xls",
					userList2);
			System.out.println("\n=== save2 finished =============\n");System.out.flush();

			ExcelPOJOBridge bridge3_1 = new ExcelPOJOBridge(UserInfo3.class);
			List<UserInfo3> userList3_1 = (List<UserInfo3>) bridge3_1.load(
																	"./files/upload/example_1.xls",
																	"Users");
			System.out.printf("\n=== UserList3_1(%s) =================\n", userList3_1.getClass());
			for (UserInfo3 userInfo : userList3_1) {
				System.out.println(userInfo.toString());
			}
			System.out.println("\n===============================\n");System.out.flush();

			bridge3_1.save("./files/template/example_template.xls",
					"Users2",
					"./files/export/Annotation_3_1.xls",
					userList3_1);
			System.out.println("\n=== save3_1 finished =============\n");System.out.flush();

			// Ame[VXML̐ݒDŒl擾
			ExcelPOJOBridge bridge3_2 = (ExcelPOJOBridge)context.getBean("UserList7");
			List<UserInfo3> userList3_2 = (List<UserInfo3>) bridge3_2.load(
																	"./files/upload/example_1.xls",
																	"Users");
			System.out.printf("\n=== UserList3_2(%s) =================\n", userList3_2.getClass());
			for (UserInfo3 userInfo : userList3_2) {
				System.out.println(userInfo.toString());
			}
			System.out.println("\n===============================\n");System.out.flush();

			bridge3_2.save("./files/template/example_template.xls",
					"Users2",
					"./files/export/Annotation_3_2.xls",
					userList3_2);
			System.out.println("\n=== save3_2 finished =============\n");System.out.flush();

			ExcelPOJOBridge bridge4 = new ExcelPOJOBridge(UserInfo4.class);
			UserInfo4[] userInfoArr = (UserInfo4[]) bridge4.load("./files/upload/example_1.xls", "Users");
			System.out.printf("\n=== userInfoArr(%s) =================\n", userInfoArr.getClass());
			for (UserInfo4 userInfo : userInfoArr) {
				System.out.println(userInfo.toString());
			}
			System.out.println("\n===============================\n");System.out.flush();

			bridge4.save("./files/template/example_template.xls",
					"Users2",
					"./files/export/Annotation_4.xls",
					userInfoArr);
			System.out.println("\n=== save4 finished =============\n");System.out.flush();

		} catch (ExcelPOJOException e) {
			e.printStackTrace();
		}
	}
}
